﻿using System;
using System.Linq;
using System.Text;

namespace ManipulatingText
{
    class Program
    {
        // Listing 10-62. Symulowanie niechlujnych danych wprowadzanych przez użytkownika
        private static string[] SoliloquizeLikeAUser()
        {
            return new string[] {
                "",
                null,
                " ",
                String.Empty,
                " Być albo nie być -- oto jest pytanie. ",
                "Kto postępuje gdoniej: ten, kto biernie ;",
                "\tStoi pod gradem zajadłych strzał losu,",
                "",
                "\tCzy ten, kto stawia opór morzu nieszczęść ",
                "I w walce kładzie im kres?",
                "",
                "",
                "",
                "",
                ""};
        }

        static void Main(string[] args)
        {
            {
                // Listing 10-63. Czyszczenie danych wejściowych.
                string[] strings = SoliloquizeLikeAUser();
                string output = String.Empty; // To odpowiednik łańcucha pusego: ""
                foreach (string line in strings)
                {
                    // W jakiś sposób analizujemy łańcuch wejściowy (line)...
                    // a następnie...
                    output = output + line + Environment.NewLine;
                }
                Console.WriteLine(output);
            }

            Console.WriteLine("-------");

            {
                // Listing 10-64. Tworzenie łańcuchów znaków przy użyciu klasy StringBuilder.
                // oraz
                // Listing 10-73. Zastosowany wcześniej kod porządkujący dane wprowadzone przez użytkownika
                string[] strings = SoliloquizeLikeAUser();
                StringBuilder output = new StringBuilder();
                foreach (string line in strings)
                {
                    // Listing 10-75. Wykrywanie pustych łańcuchów znaków.
                    //if (line != String.Empty)
                    // Listing 10-76. Sprawdzanie pustego łańcucha lub pustej referencji (null).
                    if (!String.IsNullOrEmpty(line))
                    {
                        output.AppendLine(line);
                    }
                    else
                    {
                        System.Diagnostics.Debug.WriteLine("Znaleziono pusty wiersz.");
                    }
                }

                // Listing 10-74. Poprawianie konkretnego błędu typograficznego.
                output.Replace("gdoniej", "godniej");
                Console.WriteLine(output.ToString());
            }

            Console.WriteLine("-------");

            {
                {
                    string[] strings = SoliloquizeLikeAUser();
                    StringBuilder output = new StringBuilder();
                    // Listing 10-77. Usuwanie białych znaków.
                    foreach (string line in strings)
                    {
                        if (line != null)
                        {
                            //string trimmedLine = line.Trim();
                            // Listing 10-78. Usuwanie konkretnych znaków.
                            string trimmedLine = line.Trim(' ', '\t', ';');
                            if (trimmedLine.Length != 0)
                            {
                                output.AppendLine(trimmedLine);
                            }
                            else
                            {
                                System.Diagnostics.Debug.WriteLine(
                                "Znaleziono pusty wiersz (po usunięciu białych znaków).");
                            }
                        }
                        else
                        {
                            System.Diagnostics.Debug.WriteLine("Znaleziono pusty wiersz.");
                        }
                    }

                    output.Replace("gdoniej", "godniej");
                    Console.WriteLine(output.ToString());
                }
            }
        }

        // Listing 10-79. Usuwanie wszystkich białych oraz innych podanych znaków.
        private static string TrimWhitespaceAnd(
            string inputString,
            params char[] characters)
        {
            int start = 0;
            while (start < inputString.Length)
            {
                // Jeśli znak nie jest ani białym znakiem, ani znakiem z listy,
                // to znaczy, że dotarliśmy do pierwszego nieusuwanego znaku łańcucha
                // i możemy przejść dalej.
                if (!char.IsWhiteSpace(inputString[start]) &&
                !characters.Contains(inputString[start]))
                {
                    break;
                }
                // Przesuwamy się do następnego znaku.
                start++;
            }
            // Cofamy się o jeden znak od końca ku początkowi łańcucha.
            int end = inputString.Length - 1;
            while (end >= start)
            {
                // Jeśli znak nie jest ani białym znakiem, ani znakiem z listy,
                // to znaczy, że dotarliśmy do pierwszego nieusuwanego znaku łańcucha
                // i możemy przejść dalej.
                if (!char.IsWhiteSpace(inputString[end]) &&
                !characters.Contains(inputString[end]))
                {
                    break;
                }
                // Cofamy się o jeden znak.
                end--;
            }
            // Określamy długość łańcucha na potrzeby metody Substring.
            int length = (end - start) + 1;
            if (length == inputString.Length)
            {
                // Jeśli nic nie usuwamy, to zwracamy wejściowy łańcuch 
                // znaków (nie tworzymy nowego).
                return inputString;
            }
            // Jeśli długość wynosi 0, to zwracamy pusty łańcuch znaków.
            if (length == 0)
            {
                return string.Empty;
            }
            return inputString.Substring(start, length);
        }
    }
}
